from django.shortcuts import render, get_object_or_404, redirect
from .models import NewsItem
from .forms import NewsForm
from django.contrib.auth.decorators import login_required

@login_required
def news_admin(request):
    news_items = NewsItem.objects.all().order_by('-updated_at')
    return render(request, 'news/news_admin.html', {'news_items': news_items})

@login_required
def create_news(request):
    if request.method == 'POST':
        form = NewsForm(request.POST, request.FILES)
        if form.is_valid():
            form.save()
            return redirect('news_admin')
    else:
        form = NewsForm()
    return render(request, 'news/create_news.html', {'form': form})

@login_required
def edit_news(request, pk):
    news_item = get_object_or_404(NewsItem, pk=pk)
    if request.method == 'POST':
        form = NewsForm(request.POST, request.FILES, instance=news_item)
        if form.is_valid():
            form.save()
            return redirect('news_admin')
    else:
        form = NewsForm(instance=news_item)
    return render(request, 'news/edit_news.html', {'form': form, 'news_item': news_item})
@login_required
def news_detail(request, pk):
    news_item = get_object_or_404(NewsItem, pk=pk)
    return render(request, 'news/news_detail.html', {'news_item': news_item})

@login_required
def delete_news(request, pk):
    news_item = get_object_or_404(NewsItem, pk=pk)
    if request.method == 'POST':
        news_item.delete()
        return redirect('news_admin')
    return render(request, 'news/delete_news.html', {'news_item': news_item})
