from django.db import models
from django.utils import timezone
from ckeditor.fields import RichTextField
import uuid

class BaseModel(models.Model):
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)
    id = models.UUIDField(
        default=uuid.uuid4, unique=True, primary_key=True, editable=False
    )

    class Meta:
        abstract = True

class NewsItem(BaseModel):
    headline = models.CharField(max_length=255)
    content = RichTextField()
    image = models.ImageField(upload_to='uploads/')

    def __str__(self):
        return self.headline
