from django import forms
from .models import NewsItem
from ckeditor_uploader.widgets import CKEditorUploadingWidget

class NewsForm(forms.ModelForm):
    headline = forms.CharField(
        required=True,
        error_messages={"invalid": ("Enter your headline")},
        widget=forms.TextInput(
            attrs={
                "class": "bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-sky-500 focus:border-sky-500 block w-full p-2.5",
            }
        ),
    )
    
    image = forms.ImageField(
        required=True,
        error_messages={"invalid": ("Image files only")},
        widget=forms.FileInput(
            attrs={'class': 'block w-full px-4 py-2 text-gray-700 bg-white border rounded-md border border-gray-200 focus:border-black focus:outline-none focus:ring focus:ring-blue-300 focus:ring-opacity-40'}
            ),
    )
    
    content = forms.CharField(widget=CKEditorUploadingWidget())
    
    class Meta:
        model = NewsItem
        fields = ['headline', 'content', 'image']
